package com.ejie.aa17a.control;

import java.math.BigDecimal;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.aa17a.model.Aa17aDatoHistorico;
import com.ejie.aa17a.service.iface.Aa17aDatoHistoricoService;
import com.ejie.aa17a.utilidades.Aa17aConstantes;

/**
 * Aa17aDatoHistoricoController generated by UDA, 18-dic-2013 15:36:30.
 * 
 * @author UDA
 */

@RequestMapping(value = "/datohistorico")
public class Aa17aDatoHistoricoController {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa17aDatoHistoricoController.class);

	private Aa17aDatoHistoricoService aa17aDatoHistoricoService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		Aa17aDatoHistoricoController.logger
				.info("[GET - View] : aa17adatohistorico");

		//origen de los datos para la exportacion
		model.addAttribute("tipoDatosHorarios", Aa17aConstantes.TIPO_DATOS_HORARIOS);
		model.addAttribute("tipoDatosDiarios", Aa17aConstantes.TIPO_DATOS_DIARIOS);

		//formatos de exportacion
		model.addAttribute("formato_xls", Aa17aConstantes.EXPORTAR_FORMATO_EXCEL);
		model.addAttribute("formato_pdf", Aa17aConstantes.EXPORTAR_FORMATO_PDF);
		model.addAttribute("formato_csv", Aa17aConstantes.EXPORTAR_FORMATO_CSV);

		return new ModelAndView("datohistorico", "model", model);
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterAa17aDatoHistorico
	 *            Aa17aDatoHistorico
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	List<BigDecimal[]> getAll(
			@RequestBody Aa17aDatoHistorico filterAa17aDatoHistorico) {
		Aa17aDatoHistoricoController.logger
				.info("[GET - find_ALL] : Obtener Aa17aDatoHistorico por filtro");
		return this.aa17aDatoHistoricoService.getDatosHistorico(filterAa17aDatoHistorico);
	}

	/**
	 * Method 'setAa17aDatoHistoricoService'.
	 * 
	 * @param aa17aDatoHistoricoService
	 *            Aa17aDatoHistoricoService
	 * @return
	 */
	public void setAa17aDatoHistoricoService(
			Aa17aDatoHistoricoService aa17aDatoHistoricoService) {
		this.aa17aDatoHistoricoService = aa17aDatoHistoricoService;
	}
}
